﻿//////////////////////////////////////////////
// ContextMenu.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class Component ;
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "../Themes/Color.h"

#include "Component.h"

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <functional>
#include <vector>

/// Class ------------------------------------
	
namespace nkWinUi
{
	class DLL_WINUI_EXPORT ContextMenu : public Component
	{
		public :

			// Internal item
			class DLL_WINUI_EXPORT Item
			{
				public :

					// Constructor, destructor
					Item () noexcept ;
					virtual ~Item () ;

					// Getters
					virtual nkMemory::StringView getLabel () const = 0 ;
					virtual std::function<void ()> getCallback () const = 0 ;
			} ;

		public :
		
			// Constructor, destructor
			ContextMenu (System* system) noexcept ;
			virtual ~ContextMenu () ;

			// Getters
			virtual Item* getItem (unsigned int index) const = 0 ;
			virtual unsigned int getItemCount () const = 0 ;

			// Setters
			void setAutomaticSizing (bool value) ;

			// Content creation
			virtual Item* addItem (nkMemory::StringView label, std::function<void ()> callback) = 0 ;
			virtual void addSeparator () = 0 ;
			virtual void clearItems () = 0 ;

			// View
			virtual void pop () = 0 ;

			// Recomputations
			virtual void recomputeSizeToFitItems () = 0 ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		public :

			// Statics
			static nkMemory::UniquePtr<ContextMenu> create (System* system = nullptr) ;

		protected :

			// Attributes
			// Flags
			bool _automaticSizing ;
	} ;
}